#include "encode_user_data_map.h"

#include <util/string/cast.h>

using namespace NCrypta::NSiberia::NUserDataWithDicts;
using namespace NLab::NEncodedUserData;

TEncodeUserDataMap::TEncodeUserDataMap(TTokenToIdDict&& wordDict, TTokenToIdDict&& hostDict, TTokenToIdDict&& appDict)
    : WordDict(std::move(wordDict))
    , HostDict(std::move(hostDict))
    , AppDict(std::move(appDict))
{
}

void TEncodeUserDataMap::Do(TReader* input, TWriter* output) {
    for (; input->IsValid(); input->Next()) {
        auto userData = input->GetRow();

        auto affinitiesWithDict = GetAffinitiesEncoded(userData);
        userData.MutableAffinitiesEncoded()->Swap(&affinitiesWithDict);

        output->AddRow(userData);
    }
}

NLab::TAffinitiesEncoded TEncodeUserDataMap::GetAffinitiesEncoded(const NLab::TUserData& userData) const {
    const auto& srcAffs = userData.GetAffinities();

    NLab::TAffinitiesEncoded newAffs;

    EncodeTokens(srcAffs.GetWords(), WordDict, newAffs.MutableWords());
    EncodeTokens(srcAffs.GetHosts(), HostDict, newAffs.MutableHosts());
    EncodeTokens(srcAffs.GetApps(), AppDict, newAffs.MutableApps());
    EncodeNumericTokens(srcAffs.GetAffinitiveSites(), newAffs.MutableAffinitiveSites());
    EncodeNumericTokens(srcAffs.GetTopCommonSites(), newAffs.MutableTopCommonSites());

    return newAffs;
}

void TEncodeUserDataMap::EncodeTokens(const NLab::TTokens& tokens, const TTokenToIdDict& dict, TRepeatedUint32* ids) {
    for (const auto& token: tokens.GetToken()) {
        ids->Add(dict.at(token.GetToken()));
    }
}

void TEncodeUserDataMap::EncodeNumericTokens(const NLab::TTokens& srcTokens, TRepeatedWeightedToken* dstTokens) {
    for (const auto& srcToken: srcTokens.GetToken()) {
        auto* dstToken = dstTokens->Add();
        dstToken->SetId(FromString<ui32>(srcToken.GetToken()));
        dstToken->SetWeight(srcToken.GetWeight());
    }
}

REGISTER_MAPPER(TEncodeUserDataMap);
