#pragma once

#include "helpers.h"

#include <crypta/lab/lib/native/encoded_user_data.h>
#include <crypta/lib/native/state/common.h>
#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/hash.h>

namespace NCrypta::NSiberia::NUserDataWithDicts {
    class TEncodeUserDataMap: public NYT::IMapper<NYT::TTableReader<NLab::TUserData>, NYT::TTableWriter<NLab::TUserData>> {
    public:
        TEncodeUserDataMap() = default;
        TEncodeUserDataMap(NLab::NEncodedUserData::TTokenToIdDict&& wordDict, NLab::NEncodedUserData::TTokenToIdDict&& hostDict, NLab::NEncodedUserData::TTokenToIdDict&& appDict);

        void Do(TReader* input, TWriter* output) override;

        Y_SAVELOAD_JOB(WordDict, HostDict, AppDict);

    private:
        using TRepeatedUint32 = ::google::protobuf::RepeatedField<::google::protobuf::uint32>;
        using TRepeatedWeightedToken = ::google::protobuf::RepeatedPtrField<NLab::TWeightedTokenEncoded>;

        NLab::TAffinitiesEncoded GetAffinitiesEncoded(const NLab::TUserData& userData) const;
        static void EncodeTokens(const NLab::TTokens& tokens, const NLab::NEncodedUserData::TTokenToIdDict& dict, TRepeatedUint32* ids);
        static void EncodeNumericTokens(const NLab::TTokens& srcTokens, TRepeatedWeightedToken* dstTokens);

        NLab::NEncodedUserData::TTokenToIdDict WordDict;
        NLab::NEncodedUserData::TTokenToIdDict HostDict;
        NLab::NEncodedUserData::TTokenToIdDict AppDict;
    };
}
