#include "extract_affinity_tokens_map.h"

using namespace NCrypta::NSiberia::NUserDataWithDicts;

TExtractAffinityTokensMap::TExtractAffinityTokensMap(const TOutputIndexes& outputIndexes)
    : OutputIndexes(outputIndexes)
{
}

void TExtractAffinityTokensMap::Do(TReader* input, TWriter* output) {
    for (; input->IsValid(); input->Next()) {
        const auto& row = input->GetRow();

        MapTokens(row.GetAffinities().GetWords(), output, EOutputTables::Words);
        MapTokens(row.GetAffinities().GetHosts(), output, EOutputTables::Hosts);
        MapTokens(row.GetAffinities().GetApps(), output, EOutputTables::Apps);
    }
}

void TExtractAffinityTokensMap::MapTokens(const NLab::TTokens& tokens, TWriter* output, EOutputTables tableNumber) {
    for (const auto& token: tokens.GetToken()) {
        output->AddRow(token, static_cast<size_t>(tableNumber));
    }
}

REGISTER_MAPPER(TExtractAffinityTokensMap)
