#pragma once

#include <crypta/lib/native/yt/utils/tables_indexes.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>

#include <mapreduce/yt/interface/io.h>
#include <mapreduce/yt/interface/operation.h>

namespace NCrypta::NSiberia::NUserDataWithDicts {
    class TExtractAffinityTokensMap: public NYT::IMapper<NYT::TTableReader<NLab::TUserData>, NYT::TTableWriter<NLab::TWeightedToken>> {
    public:
        enum class EOutputTables {
            Words,
            Hosts,
            Apps,
        };

        using TOutputIndexes = TTablesIndexes<EOutputTables>;

        TExtractAffinityTokensMap() = default;
        explicit TExtractAffinityTokensMap(const TOutputIndexes& outputIndexes);

        void Do(TReader* input, TWriter* output) override;

        Y_SAVELOAD_JOB(OutputIndexes);

    private:
        void MapTokens(const NLab::TTokens& tokens, TWriter* output, EOutputTables tableNumber);

        TOutputIndexes OutputIndexes;
    };
}
