#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/siberia/bin/make_user_data_encoded/lib/config.pb.h>

#include <mapreduce/yt/interface/client.h>

namespace NCrypta::NSiberia::NUserDataWithDicts {
    class TMakeUserDataWithDictJob {
    public:
        using TConfig = TMakeUserDataWithDictJobConfig;

        TMakeUserDataWithDictJob(TConfig config, NLog::TLogPtr log);

        int Do();

    private:
        void ExtractAffinityTokens(NYT::ITransactionPtr tx, const TString& srcUserDataTable, const TString& dstWords, const TString& dstHosts, const TString& dstApps);
        void PerformWordCountWithWeights(NYT::ITransactionPtr tx, const TString& weightedTokensTable, const TString& countedTokensTable);
        void MergeNewTokensIntoPriorDict(NYT::ITransactionPtr tx, const TString& newWordsTable, const TString& priorDictTable);
        void EncodeUserDataWithDicts(
                NYT::ITransactionPtr tx,
                const TString& srcUserDataTable,
                const TString& wordDictTable,
                const TString& hostDictTable,
                const TString& appDictTable,
                const TString& dstUserDataTable);

        TConfig Config;
        NLog::TLogPtr Log;
    };
}
