#include "word_count_with_weights_reduce.h"

#include <util/generic/maybe.h>

using namespace NCrypta::NSiberia::NUserDataWithDicts;

void TWordCountWithWeightsReduce::Do(TReader* input, TWriter* output) {
    TWeightedWordCount out;
    ui64 count = 0;
    for (; input->IsValid(); input->Next()) {
        const auto& row = input->GetRow();

        if (count == 0) {
            out.SetToken(row.GetToken());
            out.SetWeight(row.GetWeight());
        } else {
            auto rowWeight = row.GetWeight();
            Y_ENSURE(out.GetWeight() == rowWeight,
                     "Weights for the same word (" << out.GetToken() << ") must be equal, but they are not: " << out.GetWeight() << "!=" << rowWeight);
        }
        ++count;
    }

    out.SetCount(count);
    output->AddRow(out);
}

REGISTER_REDUCER(TWordCountWithWeightsReduce)
