from crypta.lib.python.ydb.ydb_client import YdbClient
from crypta.lib.python.ydb.yt_table_uploader import YtTableUploader
from crypta.lib.python.yql import executer
from crypta.lib.python.yql import yql_helpers
from crypta.lib.python.yt import yt_helpers
from crypta.siberia.bin.common import ydb_schemas
from crypta.siberia.bin.common.ydb.paths.proto import ydb_paths_pb2


def upload_matching_table(config, logger):
    ydb_client = YdbClient.from_proto(config.Ydb)
    yql_executer = executer.get_executer_from_proto(config.Yt)
    yt_client = yt_helpers.get_yt_client(config.Yt.Proxy, config.Yt.Pool)
    yt_table_uploader = YtTableUploader(yt_client, yql_executer, ydb_client, ydb_token_name=config.YdbTokenName, crypta_sampler_udf_url=config.CryptaSamplerUdfUrl)

    yt_client.create("map_node", config.Yt.TmpDir, recursive=True, ignore_existing=True)

    with yt_client.Transaction() as tx, yt_client.TempTable(config.Yt.TmpDir) as table_to_upload:
        logger.info("Make table")

        params = {
            "input_table": config.InputTable,
            "output_table": table_to_upload,
        }
        yql_helpers.run_query("/query/make_table_for_ydb.yql", config.Yt, params, logger, tx=tx)

        logger.info("Upload table")

        yt_table_uploader.upload(
            yt_table=table_to_upload,
            ydb_dir=ydb_paths_pb2.TYdbPaths().IdToCryptaIdDir,
            uniform_partitions=config.YdbDstTableUniformPartitions,
            yt_user_slots=config.YtUserSlots,
            ydb_table_schema=ydb_schemas.Id2CryptaId,
            denominator=config.RestSampler.Denominator,
            rest=config.RestSampler.Rest,
            sampling_field="crypta_id",
            max_job_fails=5,
            tx_id=tx.transaction_id,
        )
