#include "processor_factory.h"

#include "remove_segment_data_command_processor.h"
#include "remove_user_set_data_command_processor.h"

#include <crypta/siberia/bin/common/mutations/proto/mutation.pb.h>

#include <library/cpp/protobuf/json/json2proto.h>

using namespace NCrypta::NEventProcessing;
using namespace NCrypta::NSiberia::NMutator;

TProcessorFactory::TProcessorFactory(const TProcessorConfig& config, TYdbClient& ydbClient, TStats& stats)
    : Config(config)
    , YdbClient(ydbClient)
    , Stats(stats)
{}

IProcessorPtr TProcessorFactory::Create(const TStringBuf& commandString) const {
    const auto& mutation = NProtobufJson::Json2Proto<TMutation>(commandString, NProtobufJson::TJson2ProtoConfig().SetCastRobust(true));
    const auto& commandType = mutation.GetCommandCase();

    if (commandType == TMutation::kRemoveUserSetDataCommand) {
        return MakeHolder<TRemoveUserSetDataCommandProcessor>(mutation.GetRemoveUserSetDataCommand(), YdbClient, Stats);
    } else if (commandType == TMutation::kRemoveSegmentDataCommand) {
        return MakeHolder<TRemoveSegmentDataCommandProcessor>(mutation.GetRemoveSegmentDataCommand(), YdbClient, Stats, Config.GetMaxBatchSizePerTransaction());
    } else {
        return nullptr;
    }
}
