#include "remove_segment_data_command_processor.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/time/scope_timer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/requests/remove_users_from_segments.h>
#include <crypta/siberia/bin/common/ydb/requests/segment_exists_db_request.h>

#include <util/string/cast.h>

NCrypta::NSiberia::NMutator::TRemoveSegmentDataCommandProcessor::TRemoveSegmentDataCommandProcessor(
    TRemoveSegmentDataCommand command,
    TYdbClient& ydbClient,
    ::TStats& stats,
    ui64 maxBatchSizePerTransaction
)
    : TBase(ydbClient, stats)
    , Command(std::move(command))
    , MaxBatchSizePerTransaction(maxBatchSizePerTransaction)
{}

bool NCrypta::NSiberia::NMutator::TRemoveSegmentDataCommandProcessor::ProcessUnsafe() {
    TScopeTimer timer(Stats.Percentile, "timing.remove_segment_data");
    Stats.Count->Add("command.count.remove_segment_data");

    const auto& userSetId = Command.GetUserSetId();
    const auto& segmentId = Command.GetSegmentId();

    Log->info("Try to remove segment data for user set {} and segment {}", userSetId, segmentId);

    if (IsSegmentExists(YdbClient, userSetId, segmentId)) {
        Log->error("Segment exists in DB. Nothing to do");
        Stats.Count->Add("error.remove_segmenta_data.exists");
        return true;
    }

    Log->info("Remove users from segment {}", segmentId);
    ui64 removedUsersCount = 0;
    do {
        removedUsersCount = RemoveUsersFromSegments(YdbClient, userSetId, {segmentId}, MaxBatchSizePerTransaction);
        Log->info("Remove {} users from segment {}", removedUsersCount, segmentId);
    } while (removedUsersCount > 0);

    Log->info("Done");
    return true;
}
