#include "remove_user_set_data_command_processor.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/time/scope_timer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/common/ydb/requests/get_user_set_db_request.h>
#include <crypta/siberia/bin/common/ydb/requests/user_set_exists_db_request.h>

NCrypta::NSiberia::NMutator::TRemoveUserSetDataCommandProcessor::TRemoveUserSetDataCommandProcessor(TRemoveUserSetDataCommand command, TYdbClient& ydbClient, ::TStats& stats)
    : TBase(ydbClient, stats)
    , Command(std::move(command))
{}

bool NCrypta::NSiberia::NMutator::TRemoveUserSetDataCommandProcessor::ProcessUnsafe() {
    TScopeTimer timer(Stats.Percentile, "timing.remove_user_set_data");
    Stats.Count->Add("command.count.remove_user_set_data");

    const auto& userSetId = Command.GetUserSetId();
    const auto& userSetPath = YdbClient.GetAbsolutePath(GetUserSetDirPath(userSetId));

    Log->info("Try to remove user set {}", userSetId);

    const auto& userSet = GetUserSet(YdbClient, userSetId);

    if (userSet.Defined() && !NUserSetHelpers::IsMetaDataOnly(*userSet)) {
        Log->error("User set exists in DB without status 'meta_data_only'. Nothing to do");
        Stats.Count->Add("error.remove_user_set_data.exists");
        return true;
    }

    if (!IsPathExists(YdbClient.SchemeClient, userSetPath)) {
        Log->info("Directory {} doesn't exist. Nothing to do", userSetPath);
        return true;
    }

    RemoveDirectory(YdbClient.TableClient, YdbClient.SchemeClient, userSetPath, true);

    Log->info("User set {} is successfully removed", Command.GetUserSetId());
    return true;
}
