#include "processor_factory.h"

#include "segmentate_command_processor.h"

#include <crypta/siberia/bin/common/segmentation/proto/message.pb.h>

#include <library/cpp/protobuf/json/json2proto.h>

using namespace NCrypta::NEventProcessing;
using namespace NCrypta::NSiberia::NSegmentator;

TProcessorFactory::TProcessorFactory(const TProcessorConfig& config, TYdbClient& ydbClient, TStats& stats)
    : Config(config)
    , YdbClient(ydbClient)
    , Stats(stats)
{}

IProcessorPtr TProcessorFactory::Create(const TStringBuf& commandString) const {
    const auto& message = NProtobufJson::Json2Proto<TMessage>(commandString, NProtobufJson::TJson2ProtoConfig().SetCastRobust(true));
    const auto& commandType = message.GetBodyCase();

    if (commandType == TMessage::kSegmentateCommand) {
        return MakeHolder<TSegmentateCommandProcessor>(message.GetSegmentateCommand(), YdbClient, Stats, Config.GetBatchSizeToWrite());
    } else {
        return nullptr;
    }
}
