#pragma once

#include <crypta/lib/native/event_processing/processor_factory.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/segmentator/lib/config/proto/processor_config.pb.h>

namespace NCrypta::NSiberia::NSegmentator {
    class TProcessorFactory : public NEventProcessing::IProcessorFactory {
    public:
        TProcessorFactory(const TProcessorConfig& config, TYdbClient& ydbClient, TStats& stats);

        NEventProcessing::IProcessorPtr Create(const TStringBuf& commandString) const override;

    private:
        TProcessorConfig Config;
        TYdbClient& YdbClient;
        TStats& Stats;
    };
}
