#pragma once

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/event_processing/processor.h>
#include <crypta/siberia/bin/common/segmentation/proto/message.pb.h>

namespace NCrypta::NSiberia::NSegmentator {
    class TSegmentateCommandProcessor : public TProcessor {
        using TBase = TProcessor;

    public:
        TSegmentateCommandProcessor(
            TSegmentateCommand command,
            TYdbClient& ydbClient,
            TStats& stats,
            ui64 batchSizeToWrite);

    private:
        bool ProcessUnsafe() override;

        TSegmentateCommand Command;
        ui64 BatchSizeToWrite;
    };
}
