import argparse
import logging
import os

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.ydb.ydb_client import YdbClient
from crypta.lib.python.ydb.yt_table_uploader import YtTableUploader
from crypta.lib.python.yql import executer
from crypta.lib.python.yt import yt_helpers
from crypta.siberia.bin.common import ydb_schemas
from crypta.siberia.bin.common.ydb.paths.proto import ydb_paths_pb2
from crypta.siberia.bin.user_data_uploader.lib import config_fields


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True, type=yaml_config.load)
    parser.add_argument("--version", required=False, default=None)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    logger.info("==================== Start ====================")

    args = parse_args()
    config = args.config
    logger.info(config)

    yt_proxy = config[config_fields.YT_PROXY]
    yt_pool = config[config_fields.YT_POOL]

    ydb_client = YdbClient(config[config_fields.YDB_ENDPOINT], config[config_fields.YDB_DATABASE], os.environ["YDB_TOKEN"])
    yt_client = yt_helpers.get_yt_client(yt_proxy, yt_pool)
    yql_executer = executer.get_executer(yt_proxy, yt_pool, config[config_fields.YT_TMP_DIR])

    yt_table = config[config_fields.USER_DATA_YT_TABLE] if args.version is None else os.path.join(config[config_fields.CUSTOM_USER_DATA_YT_DIR], args.version)

    ydb_paths = ydb_paths_pb2.TYdbPaths()
    ydb_dir = ydb_paths.CryptaIdUserDataDir if args.version is None else os.path.join(ydb_paths.ExperimentalCryptaIdUserDataRootDir, args.version)

    uploader = YtTableUploader(yt_client, yql_executer, ydb_client, ydb_token_name=config[config_fields.YDB_TOKEN_NAME], crypta_sampler_udf_url=config[config_fields.CRYPTA_SAMPLER_UDF_URL])
    with yt_client.Transaction() as tx:
        uploader.upload(
            yt_table=yt_table,
            ydb_dir=ydb_dir,
            uniform_partitions=config[config_fields.USER_DATA_UNIFORM_PARTITIONS],
            yt_user_slots=config[config_fields.YT_USER_SLOTS],
            ydb_table_schema=ydb_schemas.CryptaIdUserData,
            denominator=config[config_fields.DENOMINATOR],
            rest=config[config_fields.REST],
            sampling_field="crypta_id",
            max_job_fails=5,
            tx_id=tx.transaction_id
        )

    logger.info("==================== Finish ====================")
