import collections
import json
import operator

from crypta.lib.python.spine.juggler.juggler_aggregate_check import JugglerAggregateCheck
from crypta.spine import spine


def main():
    all_checks = spine.get_config_registry().get_configs(JugglerAggregateCheck.REGISTRY_TAG)

    counts = collections.Counter((x.host, x.service) for x in all_checks)
    if counts.most_common(1)[0][1] > 1:
        raise Exception("Duplicate items: {}".format(",".join(str(k) for k in counts if counts[k] > 1)))

    print json.dumps(
        sorted((check.to_dict(True) for check in all_checks), key=operator.itemgetter("host", "service")),
        indent=4,
        sort_keys=True,
    )
