import argparse
import logging
import subprocess

from crypta.lib.python.logging import logging_helpers


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Uploads aggregate checks to juggler")
    parser.add_argument("--print-checks-bin", required=True)
    parser.add_argument("--juggler-sdk-bin", required=True)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info("args: %s", args)

    logger.info("Start")

    print_checks_process = subprocess.Popen([args.print_checks_bin], stdout=subprocess.PIPE)
    juggler_process = subprocess.Popen([args.juggler_sdk_bin, 'load'], stdin=print_checks_process.stdout, stdout=subprocess.PIPE)
    print_checks_process.stdout.close()
    juggler_response = juggler_process.communicate()[0]
    if juggler_process.returncode:
        raise Exception(juggler_response)
    if juggler_response:
        logger.info(juggler_response)

    logger.info("Finish")
