from infra.dctl.src.lib import (
    cliutil,
    stage,
)
import six
import termcolor

from crypta.spine.pushers.update_deploy_stages.lib import build_diff
from crypta.spine.pushers.update_deploy_stages.lib.fill_missing_fields import fill_missing_fields


def print_diff(diff):
    print("Diff:")
    for line in diff:
        if line[0] == "+":
            print(termcolor.colored(line, "green"))
        elif line[0] == "-":
            print(termcolor.colored(line, "red"))
        else:
            print(line)


def accept_changes(id_):
    while True:
        x = six.moves.input("Accept? (y/n):").lower()
        if x == "y":
            print("Pushing {}".format(id_))
            return True
        elif x == "n":
            print("Skipping {}".format(id_))
            return False
        else:
            print("Please choose y/n")


def apply(new, old, yaml_converter, pusher, dry_run):
    diff = build_diff.build_diff(old, new, yaml_converter)

    if not diff:
        print("No changes detected, skipping")
        return

    print_diff(diff)

    if accept_changes(new.meta.id):
        if dry_run:
            print("Dry run, will not push updates")
        else:
            pusher(new)


def put_stage(new_stage, client, dry_run):
    print('Updating stage: {}'.format(new_stage.meta.id))

    cliutil.clear_not_initializable_fields(new_stage)

    old_stage = client.get_stage(new_stage.meta.id)
    fill_missing_fields(client, new_stage, old_stage)
    stage.validate(new_stage)

    apply(new_stage, old_stage, build_diff.stage_proto_to_yaml_lines, client.push_stage, dry_run)


def put_release_rule(new_release_rule, client, dry_run):
    print('Updating release rule: {}'.format(new_release_rule.meta.id))

    cliutil.clear_not_initializable_fields(new_release_rule)

    old_release_rule = client.get_release_rule(new_release_rule.meta.id)

    apply(new_release_rule, old_release_rule, build_diff.release_rule_proto_to_yaml_line, client.push_release_rule, dry_run)
