import copy
import difflib

from infra.dctl.src.lib import cliutil

from crypta.lib.python.spine import deploy


def build_diff(old, new, convert_to_yaml_lines):
    # TODO(CRYPTA-13336) Figure out better ways to build relevant diffs

    return list(difflib.unified_diff(
        convert_to_yaml_lines(old),
        convert_to_yaml_lines(new),
        fromfile="old",
        tofile="new",
    ))


def stage_proto_to_yaml_lines(proto):
    if proto is None:
        return []

    proto_copy = copy.deepcopy(proto)

    proto_copy.meta.ClearField("acl")
    proto_copy.ClearField("labels")
    proto_copy.ClearField("annotations")
    proto_copy.spec.ClearField("revision_info")
    proto_copy.spec.ClearField("revision")

    for unit in proto_copy.spec.deploy_units.values():
        unit.ClearField("revision")
        unit.ClearField("patchers_revision")
        unit.ClearField("pod_agent_sandbox_info")
        unit.ClearField("logbroker_tools_sandbox_info")
        deploy.get_pod_agent_spec(unit).resources.SetInParent()
        for box in deploy.get_pod_agent_spec(unit).boxes:
            box.rootfs.SetInParent()

    return cliutil.dump_yp_object_to_yaml(proto_copy).splitlines()


def release_rule_proto_to_yaml_line(proto):
    if proto is None:
        return []

    proto_copy = copy.deepcopy(proto)

    proto_copy.meta.ClearField("account_id")
    proto_copy.meta.ClearField("acl")
    proto_copy.ClearField("labels")
    proto_copy.ClearField("annotations")

    return cliutil.dump_yp_object_to_yaml(proto_copy).splitlines()
