import os

YP_TOKEN = "YP_TOKEN"
DOCKER_REGISTRY_TOKEN = "DOCKER_REGISTRY_TOKEN"
SANDBOX_TOKEN = "SANDBOX_TOKEN"


def get_token(env_var, link):
    if env_var not in os.environ:
        raise Exception("{} env variable is required, get token here {}".format(env_var, link))

    return os.environ[env_var]


def get_yp_token():
    return get_token(YP_TOKEN, "https://oauth.yandex-team.ru/authorize?response_type=token&client_id=f8446f826a6f4fd581bf0636849fdcd7")


def get_docker_registry_token():
    return get_token(DOCKER_REGISTRY_TOKEN, "https://oauth.yandex-team.ru/authorize?response_type=token&client_id=12225edea41e4add87aaa4c4896431f1")


def get_sandbox_token():
    return get_token(SANDBOX_TOKEN, "https://sandbox.yandex-team.ru/oauth")
