from crypta.lib.python.spine import deploy


def fill_missing_fields(docker_client, new_stage, old_stage):
    fill_docker_images(docker_client, new_stage, old_stage)
    fill_static_resources(new_stage, old_stage)


def fill_docker_images(docker_client, new_stage, old_stage):
    docker_images = get_docker_images(old_stage)

    for key, image_proto in get_docker_images(new_stage).items():
        image_proto.tag = get_image_tag(docker_client, image_proto, docker_images.get(key))


def fill_static_resources(new_stage, old_stage):
    static_resources = get_static_resources(old_stage)

    for key, new_resource_proto in get_static_resources(new_stage).items():
        old_resource_proto = static_resources.get(key)
        if old_resource_proto and new_resource_proto.url == old_resource_proto.url:
            new_resource_proto.CopyFrom(old_resource_proto)


def get_static_resources(proto):
    if proto is None:
        return {}

    return {
        (unit_id, static_resource.id): static_resource
        for unit_id, unit in proto.spec.deploy_units.items()
        for static_resource in deploy.get_pod_agent_spec(unit).resources.static_resources
    }


def get_docker_images(proto):
    if proto is None:
        return {}

    return {
        (unit_id, box_id): image_proto
        for unit_id, unit in proto.spec.deploy_units.items()
        for box_id, image_proto in unit.images_for_boxes.items()
    }


def get_image_tag(docker_client, image_proto, old_docker_image):
    return docker_client.get_docker_tag(image_proto.registry_host, image_proto.name) \
        if old_docker_image is None or old_docker_image.name != image_proto.name\
        else old_docker_image.tag


def get_secrets(proto):
    if proto is None:
        return {}

    return {
        (unit_id, alias): secret_proto
        for unit_id, unit in proto.spec.deploy_units.items()
        for alias, secret_proto in deploy.get_secrets(unit).items()
    }
