import argparse
import json
import logging
import os
import sys

from sandbox.common import (
    rest as sandbox_rest,
    proxy as sandbox_proxy,
)

from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.spine.sandbox import sandbox_scheduler
from crypta.spine import spine
from crypta.spine.pushers.upload_sandbox_schedulers import lib

logger = logging.getLogger()

SANDBOX_TOKEN = "SANDBOX_TOKEN"


def parse_args():
    parser = argparse.ArgumentParser(description="Uploads sandbox schedulers")
    parser.add_argument("--dry-run", action="store_true", help="Print all schedulers")
    return parser.parse_args()


def main():
    logging_helpers.configure_stderr_logger(logger)

    args = parse_args()

    schedulers = spine.get_config_registry().get_configs(sandbox_scheduler.SandboxScheduler.REGISTRY_TAG)

    if args.dry_run:
        print json.dumps(
            sorted(schedulers, key=lambda x: (x["task_type"], sandbox_scheduler.get_id_from_description(x["data"]["task"]["description"]))),
            indent=4,
            sort_keys=True,
        )

    try:
        token = os.environ.get(SANDBOX_TOKEN)
        if token:
            client = sandbox_rest.Client(auth=sandbox_proxy.OAuth(token))
            lib.upload_schedulers(client, ["CRYPTA_SPINE"], schedulers, dry_run=args.dry_run)
        elif not args.dry_run:
            raise Exception("{} is not set".format(SANDBOX_TOKEN))
    except Exception:
        logger.exception("Failed to upload sandbox schedulers")
        sys.exit(1)
