import collections
import logging


logger = logging.getLogger(__name__)


def get_alerts_by_projects(alerts):
    alerts_by_projects = collections.defaultdict(dict)

    for alert in alerts:
        project_id = alert.projectId
        alert_id = alert.id

        project_alerts = alerts_by_projects[project_id]
        if alert_id in project_alerts:
            raise Exception("Duplicated alert id found. Project id = '{}', alert_name= '{}'".format(project_id, alert_id))

        project_alerts[alert_id] = alert

    return alerts_by_projects


def upload_alerts(client, alerts):
    alerts_by_projects = get_alerts_by_projects(alerts)

    for project_id, alerts_to_upload in alerts_by_projects.iteritems():
        logger.info("Processing alerts for project: '%s'", project_id)

        uploaded_alerts = {alert["id"]: alert for alert in client.list_alerts(project_id)}
        uploaded_alert_ids = set(uploaded_alerts.keys())
        alerts_ids_to_upload = set(alerts_to_upload.keys())

        alerts_to_create = alerts_ids_to_upload - uploaded_alert_ids
        logger.info("Creating alerts: %s", alerts_to_create)
        for alert_id in alerts_to_create:
            client.create_alert(alerts_to_upload[alert_id])

        alerts_to_update = alerts_ids_to_upload & uploaded_alert_ids
        logger.info("Updating alerts: %s", alerts_to_update)
        for alert_id in alerts_to_update:
            client.update_alert(alerts_to_upload[alert_id])

        alerts_to_remove = uploaded_alert_ids - alerts_ids_to_upload
        logger.info("Removing alerts: %s", alerts_to_remove)
        for alert_id in alerts_to_remove:
            client.remove_alert(project_id, alert_id)
