import argparse
import json

from crypta.lib.python.yasm import (
    yasm_client,
    templates,
    trees,
)
from crypta.lib.python.spine.yasm.yasm_dashboard import YasmDashboard
from crypta.spine import spine


def parse_args():
    parser = argparse.ArgumentParser(description="Uploads YASM templates and panels")
    parser.add_argument("--dry-run", action="store_true", help="Print all alerts")
    return parser.parse_args()


def main():
    args = parse_args()

    configs = spine.get_config_registry().get_configs(YasmDashboard.REGISTRY_TAG)

    meta_trees = {}
    for config in configs:
        meta_project = meta_trees.setdefault(config.meta_project, trees.MetaProjectTree(config.owners, config.meta_project))
        meta_project.add_panel(config.project, config.service, config.panel)

    print json.dumps(
        {
            "menu": [meta_tree.to_dict() for meta_tree in meta_trees.values()],
            "templates": templates.dump(),
        },
        indent=4,
        sort_keys=True,
    )

    client = yasm_client.YasmClient()

    if not args.dry_run:
        templates.upload(client)
        for meta_tree in meta_trees.values():
            trees.upload_meta_tree(client, meta_tree)
