"""
Get ages of oldest nodes in folders at YT and send them to graphite
"""

import argparse
import json
import logging
import sys

from crypta.spine import spine
from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.lib.python.spine.yt.yt_latency_metric import YtLatencyMetric
from crypta.lib.python.yt import metrics
from crypta.spine.pushers.yt_latencies import lib


logger = logging.getLogger(__name__)


def parse_args(description=None):
    parser = argparse.ArgumentParser(description=description)
    parser.add_argument("--config", required=True)
    parser.add_argument("--dry-run", action="store_true", help="Print config to stderr")
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args(__doc__)
    logger.info(args)

    config = yaml_config.load(args.config)
    logger.info(config)

    yt_latency_metrics_config = spine.get_config_registry().get_configs(YtLatencyMetric.REGISTRY_TAG)

    if args.dry_run:
        print >> sys.stderr, json.dumps(sorted(yt_latency_metrics_config), indent=4)
        return

    metrics.process_yt_metrics(yt_latency_metrics_config, lib.get_metrics, config["solomon"])
