import datetime

from crypta.lib.python.spine.yt import yt_latency_metric
from crypta.lib.python.yt import yt_helpers

CREATION_TIME = "creation_time"
TYPE = "type"


def get_metrics(yt_client, node):
    if not yt_client.exists(node):
        return {}

    type = yt_helpers.get_attribute(node, "type", yt_client)
    return get_map_node_metrics(yt_client, node) if type == "map_node" else get_node_metrics(yt_client, node)


def get_map_node_metrics(yt_client, map_node):
    nodes = list(yt_client.search(
        map_node,
        path_filter=lambda x: x != map_node,
        depth_bound=1,
        attributes=[CREATION_TIME, TYPE],
    ))
    table_nodes = [node for node in nodes if node.attributes[TYPE] == "table"]

    return {
        yt_latency_metric.LATENCY: get_oldest_node_age(nodes),
        yt_latency_metric.TABLE_LATENCY: get_oldest_node_age(table_nodes),
    }


def get_nodes(yt_client, map_node, node_type=None):
    return list(yt_client.search(
        map_node,
        node_type=node_type,
        path_filter=lambda x: x != map_node,
        depth_bound=1,
        attributes=[CREATION_TIME, TYPE],
    ))


def get_oldest_node_age(nodes):
    if not nodes:
        return 0

    return get_age(min(node.attributes[CREATION_TIME] for node in nodes))


def get_age(iso_ts):
    dt = datetime.datetime.strptime(iso_ts.split('.')[0], "%Y-%m-%dT%H:%M:%S")
    return (datetime.datetime.utcnow() - dt).total_seconds()


def get_node_metrics(yt_client, node):
    return {
        yt_latency_metric.AGE: get_age(yt_helpers.get_attribute(node, CREATION_TIME, yt_client)),
    }
