import yt.wrapper as yt

from crypta.lib.python.spine.yt import yt_output_table_latency_metric
from crypta.lib.python.yt import yt_helpers
from crypta.spine.pushers.yt_output_table_latencies.lib import helpers


TYPE = "type"
MAP_NODE = "map_node"
TABLE = "table"


def get_metrics(yt_client, node_path, datetime_now):
    if yt_client.exists(node_path) and yt_helpers.get_attribute(node_path, TYPE, yt_client) == MAP_NODE:
        return get_directory_output_latency(yt_client, node_path, datetime_now)
    else:
        return {}


def get_directory_output_latency(yt_client, dir_path, datetime_now):
    table_paths = helpers.get_nodes(yt_client, dir_path, TABLE)
    expected_date = helpers.get_latest_expected_date(table_paths, datetime_now)

    if expected_date is not None:
        expected_date_str = expected_date.isoformat()
        expected_table = yt.ypath_join(dir_path, expected_date_str)
        return {
            yt_output_table_latency_metric.OUTPUT_TABLE_LATENCY: helpers.get_output_table_latency(yt_client, expected_table, datetime_now),
        }
    else:
        return {}
