import datetime
import os

from crypta.lib.python import time_utils
import crypta.lib.python.spine.consts.attributes as spine_attributes
from crypta.lib.python.yt import (
    yt_helpers,
    time_utils as yt_time_utils,
)


DATE_FORMAT = "%Y-%m-%d"
CREATION_TIME_ATTR = "creation_time"


def parse_date_from_tablename(s):
    try:
        return datetime.datetime.strptime(s, DATE_FORMAT).date()
    except ValueError:
        return None


def get_latest_expected_date(table_paths, datetime_now):
    date_upper_bound = datetime_now.date()
    table_dates = [parse_date_from_tablename(os.path.basename(str(path))) for path in table_paths]

    latest_date_on_cypress = max([date for date in table_dates if date is not None and date < date_upper_bound] or [None])

    if latest_date_on_cypress is not None:
        next_date = latest_date_on_cypress + datetime.timedelta(days=1)
        return max(latest_date_on_cypress, min(next_date, date_upper_bound - datetime.timedelta(days=1)))
    else:
        return None


def get_nodes(yt_client, map_node, node_type):
    return list(yt_client.search(
        map_node,
        attributes=[],
        node_type=node_type,
        path_filter=lambda x: x != map_node,
        depth_bound=1,
    ))


def parse_date(date_str):
    return time_utils.MOSCOW_TZ.localize(datetime.datetime.strptime(date_str, DATE_FORMAT))


def get_output_table_latency(yt_client, table_path, datetime_now):
    if yt_client.exists(table_path):
        attrs = yt_helpers.get_attributes(table_path, [CREATION_TIME_ATTR, spine_attributes.GENERATE_DATETIME], client=yt_client)
        datetime_last_not_ready = yt_time_utils.yt_date_to_datetime(attrs.get(spine_attributes.GENERATE_DATETIME, attrs[CREATION_TIME_ATTR]))
    else:
        datetime_last_not_ready = datetime_now

    datetime_expected_lower_bound = parse_date(os.path.basename(table_path)) + datetime.timedelta(days=1)

    return _get_latency(datetime_expected_lower_bound, datetime_last_not_ready)


def _get_latency(datetime_expected_lower_bound, datetime_last_not_ready):
    return max((datetime_last_not_ready - datetime_expected_lower_bound).total_seconds(), 0)
