import collections
from datetime import timedelta as dt

from crypta.lib.python.spine.consts.yt_proxy import YtProxy
from crypta.lib.python.spine import arcadia_ci
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.sandbox import sandbox_scheduler


UniversalTask = collections.namedtuple("UniversalTask", ["bundle_name", "cmd", "schedule_interval", "kill_timeout", "crit_time", "yt_deps"])


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-utils"], host="crypta-utils")

    sandbox = sandbox_scheduler.create_default_generator(juggler, ["UTILS"])

    release = arcadia_ci.SpineReleaseGenerator(juggler).standard_release(
        title="YT output table latencies",
        abs_paths=["crypta/spine/pushers/yt_output_table_latencies/**"],
        auto_stable=True,
    )

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name=release.add_universal_bundle(
            package_path="crypta/spine/pushers/yt_output_table_latencies/bundle/crypta-yt-output-table-latencies.json",
        ).bundle_id,
        cmd=["yt_output_table_latencies", "--config", "config.yaml"],
        schedule_interval=dt(hours=1),
        kill_timeout=dt(hours=1),
    ).check(crit_time=dt(hours=4)).add_yt_dependencies(YtProxy.Group.offline)

    return juggler
