import datetime
import os

import pytz
import tzlocal

from crypta.lib.native.yt.processed_tables_tracker.proto.tracked_source_pb2 import TTrackedSource
from crypta.lib.python import time_utils
from crypta.lib.python.spine.yt import yt_processed_tables_metric
from crypta.lib.python.yt import processed_tables_tracker


def get_metrics(yt_client, node):
    source_dir = yt_client.get_attribute(node, processed_tables_tracker.SOURCE_DIR_ATTRIBUTE)
    tracked_source = TTrackedSource(SourceDir=source_dir, TrackTable=node)
    tracker = processed_tables_tracker.ProcessedTablesTracker(tracked_source)

    unprocessed_tables = tracker.get_unprocessed_tables(yt_client)

    if not unprocessed_tables:
        return {
            yt_processed_tables_metric.LAG: 0,
        }

    oldest_unprocessed_date = min(
        pytz.timezone("Europe/Moscow").localize(datetime.datetime.strptime(os.path.basename(table), "%Y-%m-%dT%H:%M:%S"))
        for table in unprocessed_tables
    )

    now = tzlocal.get_localzone().fromutc(datetime.datetime.utcfromtimestamp(time_utils.get_current_time()))
    return {
        yt_processed_tables_metric.LAG: (now - oldest_unprocessed_date).total_seconds(),
    }
