import datetime

from crypta.lib.python.spine import arcadia_ci
from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.consts.yt_proxy import YtProxy
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.sandbox import sandbox_scheduler


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(tags=["crypta-utils"], host="crypta-utils")

    sandbox = sandbox_scheduler.create_default_generator(juggler, ["UTILS"])

    release = arcadia_ci.SpineReleaseGenerator(juggler).standard_release(
        title="YT processed table metrics",
        abs_paths=["crypta/spine/pushers/yt_processed_tables_metrics/**"],
        auto_stable=True,
    )

    sandbox.create_run_universal_bundle_scheduler(
        bundle_name=release.add_universal_bundle(
            package_path="crypta/spine/pushers/yt_processed_tables_metrics/bundle/crypta-yt-processed-tables-metrics.json",
        ).bundle_id,
        cmd=["yt_processed_tables_metrics", "--config", "config.yaml"],
        schedule_interval=datetime.timedelta(minutes=15),
        kill_timeout=datetime.timedelta(minutes=15),
        env=environment.STABLE,
    ).check(crit_time=datetime.timedelta(hours=4)).add_yt_dependencies(YtProxy.Group.offline)

    return juggler
