import argparse
import datetime
import json
import logging
import sys

from crypta.lib.python import yaml_config
from crypta.lib.python.juggler.juggler_client import JugglerClient
from crypta.lib.python.logging import logging_helpers
from crypta.spine import spine
from crypta.lib.python.spine.yt.yt_replicated_table import ReplicatedTable
from crypta.spine.pushers.yt_replicated_table_checker.lib import check


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config", required=True, type=yaml_config.load)
    parser.add_argument("--dry-run", action="store_true", help="Print config to stderr")
    return parser.parse_args()


class Encoder(json.JSONEncoder):
    def default(self, obj):
        if isinstance(obj, datetime.timedelta):
            return obj.total_seconds()
        else:
            raise Exception("Unknown object type {}".format(type(obj)))


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info(args)

    juggler_client = JugglerClient(**args.config["juggler"])

    yt_replicated_tables_configs = spine.get_config_registry().get_configs(ReplicatedTable.REGISTRY_TAG)

    if args.dry_run:
        print >> sys.stderr, json.dumps(
            sorted((config.dump() for config in yt_replicated_tables_configs), key=lambda x: (x["master"]["proxy"], x["master"]["path"])),
            indent=4,
            cls=Encoder,
        )
        return

    for replicated_table in yt_replicated_tables_configs:
        check.check_replicated_table(juggler_client, replicated_table)
