from crypta.spine.pushers.yt_replicated_table_checker.lib import (
    master,
    replica,
)


def report(juggler_client, host, service, errors):
    if errors:
        juggler_client.send_crit(host, service, "\n".join(errors))
    else:
        juggler_client.send_ok(host, service, "OK")


def check_replicated_table(juggler_client, replicated_table):
    report(
        juggler_client,
        replicated_table.master.get_raw_juggler_host(),
        replicated_table.master.get_juggler_service(),
        master.get_errors(replicated_table),
    )

    for replica_config in replicated_table.replicas:
        report(
            juggler_client,
            replica_config.get_raw_juggler_host(),
            replica_config.get_juggler_service(),
            replica.get_errors(replica_config),
        )
