import datadiff

from crypta.lib.python.yt import yt_helpers


def check_attrs(client, path, expected_attrs_list):
    for expected_attrs in expected_attrs_list:
        actual_attrs = yt_helpers.get_attributes(path, list(expected_attrs.keys()), client)
        if expected_attrs != actual_attrs:
            return ["unexpected configuration:\n{}".format(datadiff.diff(
                expected_attrs, actual_attrs, fromfile="expected", tofile="actual",
            ))]

    return []
