from crypta.lib.python.yt import yt_helpers
from crypta.spine.pushers.yt_replicated_table_checker.lib import common


def get_errors(replica):
    try:
        client = yt_helpers.get_yt_client(replica.proxy)
        path = replica.path

        if not client.exists(path):
            return ["{} does not exist".format(path)]

        return common.check_attrs(client, path, [
            {"type": "table"},
            {"dynamic": True},
            dict(replica.expected_attributes, tablet_state="mounted"),
        ])
    except Exception as e:
        return [str(e)]
