import datetime

from crypta.lib.python import crypta_env
from crypta.lib.python.data_size import DataSize
from crypta.lib.python.spine import (
    arcadia_ci,
    deploy,
)
from crypta.lib.python.spine.consts import (
    environment,
    dc,
)
import crypta.lib.python.spine.deploy.consts as yp_consts
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.juggler.flap_detector_params import FlapDetectorParams


def get_registry():
    deploy_gen = deploy.CryptaDeployStageGenerator()
    stage = deploy_gen.stage("crypta-yt-replicated-table-checker-production")
    deploy_unit = stage.multi_cluster_deploy_unit(
        pods_per_cluster={dc.IVA: 1, dc.SAS: 1},
        cpu_ms=500,
        ram=DataSize(gb=1),
        storage=deploy.HDD(
            capacity=DataSize(gb=5),
            bandwidth_guarantee=DataSize(mb=30),
            bandwidth_limit=DataSize(mb=60),
        ),
        network_bandwidth=DataSize(mb=10),
        project_network=yp_consts.CRYPTANETS,
    ).deployment_strategy(
        max_unavailable=1
    )

    deploy_unit.box(
        docker_image="crypta/crypta-yt-replicated-table-checker",
    ).docker_release_rule(
        environment.STABLE,
    ).workload(
        start_cmd="/root/entrypoint.sh",
    ).literal_env(
        crypta_env.Production.crypta_environment
    ).secret_env(
        crypta_env.crypta_api_token
    ).secret_env(
        crypta_env.Production.yt_token
    )

    juggler = deploy_unit.get_juggler_generator(juggler_check_generator.CryptaYtCheckGenerator(
        tags=["crypta-yt"],
        warn_limit=0,
        crit_limit=1,
    ))

    flap_detector_params = FlapDetectorParams(datetime.timedelta(minutes=10), datetime.timedelta(minutes=30))
    juggler.icmpping().add_phone_escalation()
    juggler.periodic_task("yt_replicated_table_checker", crit_time=datetime.timedelta(hours=4)).add_flap_detector(flap_detector_params)

    arcadia_ci.SpineReleaseGenerator(juggler).standard_release(
        title="YT replicated table checker",
        abs_paths=[
            "crypta/spine/pushers/yt_replicated_table_checker/**",
            "crypta/utils/run_periodic_task/bin/**",
            "crypta/utils/templater/**",
            "yt/python/yt/tools/bin/lock_make/**",
        ],
        auto_stable=True,
    ).add_docker_image(
        "crypta/spine/pushers/yt_replicated_table_checker/docker/crypta-yt-replicated-table-checker.json"
    )

    return deploy_gen
