import textwrap

import crypta.adhoc.spine as adhoc
import crypta.api.spine as api
import crypta.audience.spine as audience
import crypta.buchhalter.spine as buchhalter
import crypta.cm.spine as cm
import crypta.cm.offline.spine as offline_cm
import crypta.data_import.spine as data_import
import crypta.dmp.adobe.spine as adobe
import crypta.dmp.yandex.spine as dmp
import crypta.ext_fp.spine as ext_fp
import crypta.graph.bloom_email.spine as bloom_email
import crypta.graph.fpc.spine as fpc
import crypta.graph.rtmr.spine as rt_graph
import crypta.graph.spine as graph
import crypta.lab.spine as lab
from crypta.lib.python import crypta_env
from crypta.lib.python.spine import arcadia_ci
from crypta.lib.python.spine.juggler import juggler_check_generator
import crypta.lookalike.spine as lookalike
import crypta.ltp.spine as ltp
import crypta.ml.spine as ml
from crypta.monitorings import (
    bigb_keyboard_collector,
    chyt_clique,
    yt_quotas,
)
import crypta.profile.spine as profile
import crypta.rmp.spine as rmp
import crypta.s2s.spine as s2s
import crypta.siberia.spine as siberia
import crypta.styx.spine as styx
import crypta.spine.pushers.yt_latencies.spine as yt_latencies
import crypta.spine.pushers.yt_output_table_latencies.spine as yt_output_table_latencies
import crypta.spine.pushers.yt_processed_tables_metrics.spine as yt_processed_tables_metrics
import crypta.spine.pushers.yt_replicated_table_checker.spine as yt_replicated_table_checker
import crypta.spine.pushers.yt_sizes.spine as yt_sizes
import crypta.tx.spine as tx
import crypta.utils.rtmr_resource_service.spine as resource_service
import crypta.utils.yt_stats.spine as yt_stats
import crypta.web.lab.spine as web_lab


def get_spine_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(host="crypta-spine")
    registry = arcadia_ci.SpineReleaseGenerator(juggler)

    registry.run_cmd_release(
        title="Push juggler aggregate checks",
        abs_paths=["crypta/spine/pushers/aggregate_checks/**"],
        cmd=textwrap.dedent("""
            ./ya make crypta/spine/pushers/aggregate_checks/bin --stat
            ./ya make contrib/python/juggler_sdk/cli --stat
            crypta/spine/pushers/aggregate_checks/bin/aggregate_checks | contrib/python/juggler_sdk/cli/juggler_cli load
        """)
    ).run_job.add_secret(crypta_env.juggler_oauth_token)

    registry.run_cmd_release(
        title="Push solomon alerts",
        abs_paths=["crypta/spine/pushers/upload_solomon_alerts/**"],
        cmd=textwrap.dedent("""
            ./ya make crypta/spine/pushers/upload_solomon_alerts/bin --stat
            crypta/spine/pushers/upload_solomon_alerts/bin/upload_solomon_alerts
        """)
    ).run_job.add_secret(crypta_env.solomon_token)

    registry.run_cmd_release(
        title="Push sandbox schedulers",
        abs_paths=["crypta/spine/pushers/upload_sandbox_schedulers/**"],
        cmd=textwrap.dedent("""
            ./ya make crypta/spine/pushers/upload_sandbox_schedulers/bin --stat
            crypta/spine/pushers/upload_sandbox_schedulers/bin/upload_sandbox_schedulers
        """)
    ).run_job.add_secret(crypta_env.sandbox_token)

    registry.run_cmd_release(
        title="Push YASM dashboards",
        abs_paths=["crypta/spine/pushers/yasm_dashboards/**"],
        cmd=textwrap.dedent("""
            ./ya make crypta/spine/pushers/yasm_dashboards/bin --stat
            crypta/spine/pushers/yasm_dashboards/bin/yasm_dashboards
        """)
    )

    return juggler


def get_config_registry():
    registry = get_spine_registry()

    for module in [
        adhoc,
        adobe,
        api,
        audience,
        bigb_keyboard_collector,
        bloom_email,
        buchhalter,
        chyt_clique,
        cm,
        data_import,
        dmp,
        ext_fp,
        fpc,
        graph,
        lab,
        lookalike,
        ltp,
        ml,
        offline_cm,
        profile,
        resource_service,
        rmp,
        rt_graph,
        s2s,
        siberia,
        styx,
        tx,
        web_lab,
        yt_latencies,
        yt_output_table_latencies,
        yt_processed_tables_metrics,
        yt_quotas,
        yt_replicated_table_checker,
        yt_sizes,
        yt_stats,
    ]:
        registry.add_subregistry(module.get_registry())

    return registry
