EXECTEST()

OWNER(
    g:crypta
    g:crypta-styx
)

RUN(
    NAME testing_config
    CWD ${ARCADIA_ROOT}/crypta/styx/services/api/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "testing", "dc": "man", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME stable_config
    CWD ${ARCADIA_ROOT}/crypta/styx/services/api/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "production", "dc": "sas", "fqdn": "localhost"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

RUN(
    NAME testing_qa
    CWD ${ARCADIA_ROOT}/crypta/styx/services/api/bundle/templates

    render_and_check_yaml
    --template config.yaml
    --output ${TEST_CASE_ROOT}/output.yaml
    --context '{"environment": "qa", "min_delete_interval_sec": 999, "dc": "qa", "fqdn": "localhost", "port": 1234, "ping_id": "foo", "replica_yt_proxy": "replica-proxy", "replica_table_path": "/table/path", "logs_dir": "/logs", "self_tvm_id": 123, "access_log_topic": "access-log", "change_log_server": "lbkx", "change_log_topic": "change-log"}'

    CANONIZE_LOCALLY ${TEST_CASE_ROOT}/output.yaml
)

DATA(
    arcadia/crypta/styx/services/api/bundle/templates/config.yaml
)

DEPENDS(
    crypta/utils/render_and_check_yaml
)

END()
