#pragma once

#include <crypta/lib/native/http/request_reply.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/styx/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/styx/services/api/lib/logic/common/delete_processor_base/request/delete_request.h>
#include <crypta/styx/services/api/lib/logic/common/mutation_sender/mutation_sender.h>
#include <crypta/styx/services/api/lib/logic/common/request_processor/request_processor.h>

#include <util/system/types.h>

namespace NCrypta::NStyx::NApi {
    class TDeleteProcessorBase : public TRequestProcessor {
    public:
        TDeleteProcessorBase(TMutationSender& mutationSender, const TString& handlePath, NLog::TLogPtr log, TStats& stats);
        ~TDeleteProcessorBase() override = default;

    protected:
        virtual void ParseRequest(NHttp::TRequestReply& reply, TDeleteRequest& request) const = 0;

        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) override;
        void Respond(NHttp::TRequestReply& reply);
        void RespondError(NHttp::TRequestReply& reply, const TString& code, const TString& message);

        TMutationSender& MutationSender;
        const TString HandlePath;
    };
}
