#include "mutation_sender.h"

#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/styx/services/common/mutation_commands/mutation_command.pb.h>
#include <crypta/styx/services/common/mutation_commands/serializers.h>

#include <util/system/types.h>

using namespace NCrypta::NStyx::NApi;

namespace {
    const THash<ui64> HASH;
}

TMutationSender::TMutationSender(NPQ::IProducer& producer)
    : Producer(producer)
{
}

void TMutationSender::DeletePuid(ui64 puid) {
    TMutationCommand command;
    auto* deleteCommand = command.MutableDelete();
    deleteCommand->SetPuid(puid);
    deleteCommand->SetUnixtime(TShiftedClock::Now().Seconds());

    Producer.TryEnqueue(HASH(puid), NMutationSerializers::ToJson(command));
}
