#include "request_processor.h"

#include <crypta/lib/native/time/utils.h>

#include <util/string/builder.h>

using namespace NCrypta::NStyx::NApi;
using namespace NCrypta::NHttp;

TRequestProcessor::TRequestProcessor(NLog::TLogPtr log, TStats &stats)
        : Log(log)
        , Stats(stats)
{
}

void TRequestProcessor::Process(NHttp::TRequestReply& reply, const TClient& clientInfo) {
    Y_ENSURE(!reply.IsReplied(), "TRequestReply must be ready for reply when passed to TRequestProcessor::Process");

    try {
        DoProcess(reply, clientInfo);
    } catch (const std::exception& e) {
        SendInternalError(reply, TStringBuilder() << "Exception: " << e.what());
    } catch (...) {
        SendInternalError(reply, "Unknown exception");
    }
}

void TRequestProcessor::SendResponse(NHttp::TRequestReply& reply, HttpCodes httpCode, const TString& response) {
    reply.Reply(httpCode, response, Stats, Log);
}

void TRequestProcessor::SendInternalError(NHttp::TRequestReply& reply, const TString& error) {
    Stats.Count->Add("errors.internal");
    reply.ReplyError(HTTP_INTERNAL_SERVER_ERROR, error, Stats, Log);
}
