#include "request_with_tvm_puids_parser.h"

#include <library/cpp/http/misc/parsed_request.h>

#include <util/string/builder.h>

#include <algorithm>

using namespace NCrypta::NStyx::NApi;

namespace {
    const TString HANDLE = "/1/takeout/status/";
}

void NRequestWithTvmPuidsParser::Parse(const TString& query, const TMaybe<NTvmAuth::TCheckedUserTicket>& userTicket, TRequestWithPuids& result) {
    TParsedHttpLocation httpLocation(query);
    Y_ENSURE(httpLocation.Path == TStringBuilder() << HANDLE, "Request path != '" << HANDLE << "': " << httpLocation.Path);
    Parse(TCgiParameters(httpLocation.Cgi), userTicket, result);
}

void NRequestWithTvmPuidsParser::Parse(const TCgiParameters& cgi, const TMaybe<NTvmAuth::TCheckedUserTicket>& userTicket, TRequestWithPuids& result) {
    if (!userTicket.Defined() || !(*userTicket)) {
        throw yexception() << "No user ticket, or invalid user ticket provided";
    }

    result.Subclient = cgi.Get("subclient");
    result.RequestId = cgi.Get("request_id");
    result.DefaultPuid = userTicket->GetDefaultUid();
}
