#pragma once

#include <crypta/lib/native/http/request_reply.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/yt/dyntables/async_database/kv_database.h>
#include <crypta/styx/services/api/lib/config/clients/clients_config.pb.h>
#include <crypta/styx/services/api/lib/logic/common/request_processor/request_processor.h>
#include <crypta/styx/services/api/lib/logic/common/request_with_puids/request_with_puids.h>
#include <crypta/styx/services/common/db_state/db_state.h>

#include <util/system/types.h>

namespace NCrypta::NStyx::NApi {
    class TStatusProcessorBase : public TRequestProcessor {
    public:
        TStatusProcessorBase(
                NYtDynTables::TKvDatabase& replicaDatabase,
                TDuration minDeleteInterval,
                const TString& handlePath,
                NLog::TLogPtr log,
                TStats& stats);
        ~TStatusProcessorBase() override = default;

    protected:
        virtual void ParseRequest(NHttp::TRequestReply& reply, TRequestWithPuids& request) const = 0;

        void DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) override;

        void Respond(NHttp::TRequestReply& reply, ui64 defaultPuid, const TDbState::TPuidStates& puidStates);
        void RespondError(NHttp::TRequestReply& reply, const TString& message);

        NYtDynTables::TKvDatabase& ReplicaDatabase;
        const TDuration MinDeleteInterval;
        const TString HandlePath;
    };
}
