#include "delete_processor.h"

#include <crypta/styx/services/api/lib/logic/delete/request_parser/delete_request_parser.h>

namespace {
    const TString& HANDLE = "1/takeout/delete/";
    const TString& LOG = "delete";
}

using namespace NCrypta::NStyx::NApi;

TDeleteProcessor::TDeleteProcessor(TMutationSender& mutationSender, const TStats::TSettings& statsSettings)
    : TDeleteProcessorBase(mutationSender, HANDLE, NLog::GetLog(LOG), TaggedSingleton<TStats, decltype(*this)>(LOG, statsSettings))
{
}

void TDeleteProcessor::ParseRequest(NHttp::TRequestReply& reply, TDeleteRequest& request) const {
    NDeleteRequestParser::Parse(TCgiParameters(reply.GetRequestCgi()), reply.GetRequestBody(), reply.GetUserTicket(), request);
}
