#include "delete_request_parser.h"

#include <crypta/styx/services/api/lib/logic/common/request_with_puids/request_with_tvm_puids_parser.h>
#include <crypta/styx/services/api/lib/logic/delete/request_parser/delete_body.pb.h>

#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <library/cpp/http/misc/parsed_request.h>

using namespace NCrypta::NStyx::NApi;

void NDeleteRequestParser::Parse(const TCgiParameters& cgi, TStringBuf body, const TMaybe<NTvmAuth::TCheckedUserTicket>& userTicket, TDeleteRequest& result) {
    NRequestWithTvmPuidsParser::Parse(cgi, userTicket, result);

    TDeleteBody deleteBody;
    NProtoSerializer::FromJson(deleteBody, body);

    size_t idCount = deleteBody.IdSize();
    result.ServiceIds.reserve(idCount);
    for (size_t i = 0; i < idCount; ++i) {
        result.ServiceIds.push_back(deleteBody.GetId(i));
    }
}
