#include "delete_private_processor.h"

#include <crypta/styx/services/api/lib/logic/delete_private/request_parser/delete_private_request_parser.h>

namespace {
    const TString& HANDLE = "delete_private";
}

using namespace NCrypta::NStyx::NApi;

TDeletePrivateProcessor::TDeletePrivateProcessor(TMutationSender& mutationSender, const TStats::TSettings& statsSettings)
    : TDeleteProcessorBase(mutationSender, HANDLE, NLog::GetLog(HANDLE), TaggedSingleton<TStats, decltype(*this)>(HANDLE, statsSettings))
{
}

void TDeletePrivateProcessor::ParseRequest(NHttp::TRequestReply& reply, TDeleteRequest& request) const {
    NDeletePrivateRequestParser::Parse(TCgiParameters(reply.GetRequestCgi()), request);
}
