#include "delete_private_request_parser.h"

#include <crypta/styx/services/api/lib/logic/common/request_with_puids/request_with_url_puids_parser.h>

#include <library/cpp/http/misc/parsed_request.h>

#include <util/generic/string.h>
#include <util/generic/yexception.h>
#include <util/string/builder.h>

using namespace NCrypta::NStyx::NApi;

void NDeletePrivateRequestParser::Parse(const TCgiParameters& cgi, TDeleteRequest& result) {
    NRequestWithUrlPuidsParser::Parse(cgi, static_cast<TRequestWithPuids&>(result));

    auto& ids = result.ServiceIds;
    ids.clear();

    auto idsCount = cgi.NumOfValues("service_id");
    for (size_t i = 0; i < idsCount; ++i) {
        ids.push_back(cgi.Get("service_id", i));
    }
}
