#include "ping_processor.h"

#include <crypta/lib/native/singleton/tagged_singleton.h>
#include <crypta/lib/native/time/scope_timer.h>
#include <crypta/lib/native/http/request_parser/request_parser.h>

#include <library/cpp/svnversion/svnversion.h>

#include <util/string/builder.h>

using namespace NCrypta::NHttp;
using namespace NCrypta::NStyx::NApi;

TPingProcessor::TPingProcessor(
        const TPingConfig& pingConfig,
        const NTvmAuth::TTvmClient& tvmClient,
        const TStats::TSettings& statsSettings)
    : TRequestProcessor(NLog::GetLog("ping"), TaggedSingleton<TStats, decltype(*this)>("ping", statsSettings))
    , PingId(pingConfig.GetPingId())
    , TvmClient(tvmClient)
{
}

void TPingProcessor::DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) {
    TScopeTimer scopeTimer(Stats.Percentile, "timing.process");

    Stats.Count->Add("request.total.received");
    Stats.Count->Add("tvm_client." + clientInfo.GetName());

    NHttp::TRequest request;
    try {
        request = NRequestParser::Parse(TCgiParameters(reply.GetRequestCgi()));
    } catch (const yexception& e) {
        SendResponse(reply, HTTP_BAD_REQUEST, e.what());
        return;
    }

    Stats.Count->Add("subclient." + clientInfo.GetName() + "." + request.Subclient);

    const auto tvmStatus = TvmClient.GetStatus();
    if (tvmStatus == NTvmAuth::TClientStatus::Error) {
        SendResponse(reply, HTTP_INTERNAL_SERVER_ERROR, ::TStringBuilder() << "Bad TVM client status: " << tvmStatus.GetCode());
        return;
    }

    SendResponse(reply, HTTP_OK, "pong");
}
