#include "status_processor.h"

#include <crypta/lib/native/tvm/headers.h>
#include <crypta/styx/services/api/lib/logic/common/request_with_puids/request_with_tvm_puids_parser.h>

namespace {
    const TString& HANDLE = "1/takeout/status/";
    const TString& LOG = "status";
}

using namespace NCrypta::NStyx::NApi;

TStatusProcessor::TStatusProcessor(NYtDynTables::TKvDatabase& replicaDatabase, TDuration minDeleteInterval, const TStats::TSettings& statsSettings)
        : TStatusProcessorBase(replicaDatabase, minDeleteInterval, HANDLE, NLog::GetLog(LOG), TaggedSingleton<TStats, decltype(*this)>(LOG, statsSettings))
{
}

void TStatusProcessor::ParseRequest(NHttp::TRequestReply& reply, TRequestWithPuids& request) const {
    NRequestWithTvmPuidsParser::Parse(TCgiParameters(reply.GetRequestCgi()), reply.GetUserTicket(), request);
}
