#include "status_private_processor.h"

#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/singleton/tagged_singleton.h>
#include <crypta/styx/services/api/lib/logic/common/request_with_puids/request_with_url_puids_parser.h>

namespace {
    const TString& HANDLE = "status_private";
}

using namespace NCrypta::NStyx::NApi;

TStatusPrivateProcessor::TStatusPrivateProcessor(NYtDynTables::TKvDatabase& replicaDatabase, TDuration minDeleteInterval, const TStats::TSettings& statsSettings)
    : TStatusProcessorBase(
            replicaDatabase,
            minDeleteInterval,
            HANDLE,
            NLog::GetLog(HANDLE),
            TaggedSingleton<TStats, decltype(*this)>(HANDLE, statsSettings))
{
}

void TStatusPrivateProcessor::ParseRequest(NHttp::TRequestReply& reply, TRequestWithPuids& request) const {
    NRequestWithUrlPuidsParser::Parse(TCgiParameters(reply.GetRequestCgi()), request);
}
