#include "version_processor.h"

#include <crypta/lib/native/http/request_parser/request_parser.h>
#include <crypta/lib/native/singleton/tagged_singleton.h>
#include <crypta/lib/native/time/scope_timer.h>

#include <library/cpp/svnversion/svnversion.h>

#include <util/string/builder.h>

using namespace NCrypta::NStyx::NApi;

TVersionProcessor::TVersionProcessor(const TStats::TSettings& statsSettings)
        : TRequestProcessor(NLog::GetLog("version"), TaggedSingleton<TStats, decltype(*this)>("version", statsSettings))
{
}

void TVersionProcessor::DoProcess(NHttp::TRequestReply& reply, const TClient& clientInfo) {
    TScopeTimer scopeTimer(Stats.Percentile, "timing.process");

    Stats.Count->Add("request.total.received");
    Stats.Count->Add("tvm_client." + clientInfo.GetName());

    NHttp::TRequest request;
    try {
        request = NHttp::NRequestParser::Parse(TCgiParameters(reply.GetRequestCgi()));
    } catch (const yexception& e) {
        SendResponse(reply, HTTP_BAD_REQUEST, e.what());
        return;
    }

    Stats.Count->Add("subclient." + clientInfo.GetName() + "." + request.Subclient);

    SendResponse(reply, HTTP_OK, TStringBuilder()
            << "Crypta Styx API\nBuilt from Arcadia rev. "
            << GetProgramSvnRevision());
}
